import { handleActions } from "redux-actions";
import {
    receiveMyRoles,
    receivePublicCryptaId,
    receivePublicGraph,
    receivePublicProfile,
    receivePublicTransactions,
    requestMyRoles,
    requestPublicCryptaId,
    requestPublicGraph,
    requestPublicProfile,
    requestPublicTransactions,
} from "./actions";

const DEFAULT_STATE = {
    myRoles: {
        data: [],
        loading: true,
    },
    cryptaId: {
        data: null,
        loading: true,
    },
    profile: {
        data: {},
        loading: true,
    },
    transactions: {
        data: [],
        loading: true,
    },
    graph: {
        data: {},
        loading: true,
    },
};

export const publicInfo = handleActions(
    {
        [requestMyRoles]: (state) => ({
            ...state,
            myRoles: {
                data: [],
                loading: true,
            },
        }),
        [receiveMyRoles]: (state, { payload }) => ({
            ...state,
            myRoles: {
                data: payload,
                loading: false,
            },
        }),
        [requestPublicCryptaId]: (state) => ({
            ...state,
            cryptaId: {
                data: null,
                loading: true,
            },
            profile: {
                data: {},
                loading: true,
            },
            transactions: {
                data: [],
                loading: true,
            },
        }),
        [receivePublicCryptaId]: (state, { payload }) => {
            if (payload) {
                return {
                    ...state,
                    cryptaId: {
                        data: payload,
                        loading: false,
                    },
                };
            }
            else {
                return {
                    ...state,
                    cryptaId: {
                        data: null,
                        loading: false,
                    },
                    profile: {
                        data: {},
                        loading: false,
                    },
                    transactions: {
                        data: [],
                        loading: false,
                    },
                }
            }
        },
        [requestPublicProfile]: (state) => ({
            ...state,
            profile: {
                data: {},
                loading: true,
            },
        }),
        [receivePublicProfile]: (state, { payload }) => ({
            ...state,
            profile: {
                data: payload,
                loading: false,
            },
        }),
        [requestPublicTransactions]: (state) => ({
            ...state,
            transactions: {
                data: [],
                loading: true,
            },
        }),
        [receivePublicTransactions]: (state, { payload }) => ({
            ...state,
            transactions: {
                data: payload,
                loading: false,
            },
        }),
        [requestPublicGraph]: (state) => ({
            ...state,
            graph: {
                data: {},
                loading: true,
            },
        }),
        [receivePublicGraph]: (state, { payload }) => ({
            ...state,
            graph: {
                data: payload,
                loading: false,
            },
        }),
    },
    DEFAULT_STATE,
);

