import { createSelector } from "reselect";

export const getPublicInfo = state => state.publicInfo;

export const getMyRoles = createSelector([getPublicInfo], publicInfo => publicInfo.myRoles.data);
export const getMyRolesLoading = createSelector([getPublicInfo], publicInfo => publicInfo.myRoles.loading);

export const getPublicCryptaId = createSelector([getPublicInfo], publicInfo => publicInfo.cryptaId.data);
export const getPublicCryptaIdLoading = createSelector([getPublicInfo], publicInfo => publicInfo.cryptaId.loading);

export const getPublicProfile = createSelector([getPublicInfo], publicInfo => publicInfo.profile.data);
export const getPublicProfileLoading = createSelector([getPublicInfo], publicInfo => publicInfo.profile.loading);

export const getPublicGraph = createSelector([getPublicInfo], publicInfo => publicInfo.graph.data);
export const getPublicGraphLoading = createSelector([getPublicInfo], publicInfo => publicInfo.graph.loading);

export const getExactDemographics = createSelector([getPublicProfile], e => e.exactDemographics);
export const getGender = createSelector([getExactDemographics], e => e?.gender);
export const getZodiac = createSelector([getPublicProfile], e => e?.zodiacSign?.name);

export const getTopInterests = createSelector([getPublicProfile], profile => profile.interestsTop ?? []);

export const getInterests = createSelector(
    [getPublicProfile],
    profile => {
        const interests = new Map();

        profile.interests?.forEach(interest => {
            if (!interests.has(interest.groupName)) {
                interests.set(interest.groupName, []);
            }

            interests.get(interest.groupName).push(interest.name);
        });

        return [...interests.entries()].map(([key, value]) => ({
            name: key,
            subItems: value.filter(e => e !== key),
        }));
    },
);

export const getRegularGeo = createSelector([getPublicProfile], profile => profile.regularGeo ?? []);

export const getPublicTransactions = createSelector([getPublicInfo], publicInfo => publicInfo.transactions.data);
export const getPublicTransactionsLoading = createSelector([getPublicInfo], publicInfo => publicInfo.transactions.loading);

export const getTransactions = createSelector(
    [getPublicTransactions],
    transactions => transactions.map(e => ({ name: e.category, amount: e.price })),
);
