import { API } from "../../utils/apiClient";

export function getMyRoles() {
    return API.then((api) => {
        return api.idm
            .getMyRoles().then((response) => {
                return response.obj;
            });
    });
}

export function getPublicProfile(cryptaId) {
    return API.then((api) => {
        return api.portal
            .getPublicProfile({
                uidType: "CRYPTA_ID",
                uid: cryptaId,
            }).then((response) => {
                return response.obj;
            });
    });
}

export function getPublicTransactions(cryptaId) {
    return API.then((api) => {
        return api.portal
            .getPublicTransactions({
                uidType: "CRYPTA_ID",
                uid: cryptaId,
            }).then((response) => {
                return response.obj;
            });
    });
}

export function getPublicGraph(cryptaId) {
    return API.then((api) => {
        return api.portal
            .getPublicGraph({
                crypta_id: cryptaId,
            }).then((response) => {
                return response.obj;
            });
    });
}

export function getPublicCryptaId(id) {
    return API.then((api) => {
        return api.portal
            .getPublicCryptaId({
                id,
            }).then((response) => {
                return response.obj;
            });
    });
}
