const GENDER_TO_NAME = {
    male: "Мужчина",
    female: "Женщина",
};

const AGE_SEGMENT_TO_NAME = {
    from0to17: "до 17 лет",
    from18To24: "от 18 до 24 лет",
    from25To34: "от 25 до 34 лет",
    from35To44: "от 35 до 44 лет",
    from45To54: "от 45 до 54 лет",
    from55To99: "55 лет и старше",
};

const INCOME_SEGMENT_TO_NAME = {
    A: "Низкий доход",
    B1: "Доход ниже среднего",
    B2: "Доход выше среднего",
    C1: "Высокий доход",
    C2: "Премиум доход",
};

export function convertGenderToText(gender) {
    return GENDER_TO_NAME[gender];
}

export function convertAgeSegmentToText(ageSegment) {
    return AGE_SEGMENT_TO_NAME[ageSegment];
}

export function convertIncomeSegmentToText(incomeSegment) {
    return INCOME_SEGMENT_TO_NAME[incomeSegment];
}

export function convertMarriedToText(gender, married) {
    return married
        ? (gender === "male" ? "Женаты" : "Замужем")
        : (gender === "male" ? "Холосты" : "Не замужем");
}

export function convertMarriedToSingleText(gender, married) {
    return married
        ? (gender === "male" ? "Женат" : "Замужем")
        : (gender === "male" ? "Холост" : "Не замужем");
}

export function convertHasChildrenToText(hasChildren) {
    return hasChildren ? "Есть дети" : "Нет детей";
}
