import { combineReducers } from "redux";

import { graph } from "graph/search/loader/graphReducers";
import { graphExport } from "graph/search/dot/graphExportReducers";
import { selectReducer } from "graph/selectReducers";
import { graphInfo } from "graph/info/reducers";
import { graphSettings } from "graph/search/settings/settingsReducers";
import { idInfo } from "graph/info/reducers";
import { bigbProfileSettings } from "src/bb-profile/settings/settingsReducers";
import { connectRouter } from "connected-react-router";
import { pages } from "src/ad/pages/reducers";
import { ad } from "src/ad/ad/reducers";
import { selectTypes } from "src/ad/selectTypes/reducers";
import { bmCategories } from "src/bb-profile/bm-categories/reducers";
import { commonProfiles } from "src/bb-profile/common-profiles/reducers";
import { userAgents } from "src/ad/useragent/reducers";
import { searchText } from "src/ad/searchText/reducers";
import { targetDomains } from "src/bb-profile/target-domains/reducers";
import { topAffinitySites, topSites } from "src/bb-profile/top-sites/reducers";
import { debugCookie } from "src/ad/debugCookie/reducers";
import { bbProfile, counterInfo } from "src/bb-profile/reducers";
import { geoReducer } from "src/geo/reducers";
import {
    activeExperiments,
    experiments,
    me,
    transactions,
} from "src/me/reducers";
import { timeline } from "src/graph/timelineReducers";
import { publicInfo } from "../public-info/store/reducers";
import { notificationsReducer } from "../utils/notifications/notificationsState";
import { envReducer } from "../utils/base";
import { metrikaReducer } from "../metrika";
import { entityCounters } from "src/bb-profile/entity-counters/reducers";

export default (history) =>
    combineReducers({
        env: envReducer,
        me,
        counterInfo,
        pages,
        graph,
        graphInfo,
        idInfo,
        graphSettings,
        graphExport,
        select: selectReducer,
        timeline,
        router: connectRouter(history),
        geo: geoReducer,
        bigbProfileSettings,
        ad,
        selectTypes,
        bmCategories,
        commonProfiles,
        userAgents,
        searchText,
        targetDomains,
        topAffinitySites,
        topSites,
        debugCookie,
        bbProfile,
        experiments,
        activeExperiments,
        transactions,
        publicInfo,
        notifications: notificationsReducer,
        metrika: metrikaReducer,
        entityCounters,
    });
