import React, { useState, useEffect } from "react";
import { connect, useDispatch } from "react-redux";
import FontAwesome from "react-fontawesome";
import { v4 as uuidv4 } from "uuid";
import { shuffle } from "lodash";

import PCode from "@lib/components/pcode";
import Loading from "@lib/components/loading";
import { Icon, Select } from "@lib/components/lego";

import { getAdJson } from "src/utils/apiClient";
import { getUid } from "src/selectors";
import { getUidType } from "src/selectors";

import "./index.scss";

function fetchAds(uid, uidType, experiment) {
    let parameters = {
        "imp-id": "431",
        "target-ref": "https://yandex.ru/pogoda"
    };
    let page = "49688";
    let userAgent = navigator.userAgent;
    let debugCookie = "";
    let debugMode = "SIMPLE";

    let fetch = (params) => getAdJson(page, params, uid, uidType, userAgent, debugCookie, debugMode);

    let control = fetch(JSON.stringify(parameters));
    let test = fetch(JSON.stringify({ ...parameters, "experiment-id": experiment}));

    return Promise.all([control, test]).then(values => {
        const [control, test] = values;
        return { control: control.obj.body, test: test.obj.body };
    })
}

function LikeButton(props) {
    return <div className="Like" onClick={ props.onClick }>
        <FontAwesome name="thumbs-up" />
    </div>;
}

function RandomOrder(props) {
    console.log(props);
    return <>
        { shuffle(props.children) }
    </>;
}

function getResponseId(response) {
    return JSON.parse(response).rtbAuctionInfo.bidReqId;
}

const Sbs = connect((state) => ({
    uid: getUid(state),
    uidType: getUidType(state),
}))((props) => {
    const { uid, uidType } = props;

    const newSession = () => uuidv4();
    const [ session, setSession ] = useState(newSession);
    const [ data, setData ] = useState(null);
    const [ experiment, setExperiment ] = useState("11957");

    const resetSession = () => {
        setData(null);
        setSession(newSession());
    }
    const submitLike = (type) => () => {
        resetSession();
        let submitParameters = {
            type: type,
            control: getResponseId(data.control),
            test: getResponseId(data.test),
        };
        ym(36655785, 'reachGoal', 'sbsSubmit', submitParameters);
    }

    useEffect(() => {
        fetchAds(uid, uidType, experiment)
            .then(result => setData(result))
            .catch(error => window.alert(error));
    }, [uid, uidType, session, experiment]);

    let loaded = (data !== null);

    return <div className="Sbs">
        <div className="Parameters">
            <div>На какой эксперимент смотрим?</div>
            <Select
                size="m"
                view="default"
                value={ experiment }
                onChange={ (event) => setExperiment(event.target.value) }
                options={[
                    { value: "11957", content: "11957, Реверс LTP" },
                ]}
            />
            <div className="TheQuestion">Какой набор баннеров релевантнее?</div>
        </div>
        <Loading loaded={ loaded }>
        { loaded && <div className="Blocks">
                <RandomOrder>
                    <div className="Control Block">
                        <PCode data={ data.control } />
                        <LikeButton type="control" onClick={ submitLike("control") } />
                    </div>
                    <div className="Test Block">
                        <PCode data={ data.test } />
                        <LikeButton type="test" onClick={ submitLike("test") } />
                    </div>
                </RandomOrder>
            </div>
        }
        </Loading>
    </div>;
});

export default Sbs;
