import { createSelector } from "reselect";
import { getSearchObject } from "src/selectors/router";
import { COMMON_YANDEXUID } from "src/common/Names";
import { isUndefined } from "lodash";

export const getAdParameters = createSelector([getSearchObject], (search) => ({
    "stat-id": search["stat-id"] || "",
    charset: search["charset"] || "utf-8",
    callback: search["callback"] || "Ya[4195286797107]",
    "tune-region-id": search["tune-region-id"] || "213",
    "enable-flat-highlight": search["enable-flat-highlight"] || "1",
    "skip-banner": search["skip-banner"] || "",
    "layout-config": search["layout-config"] || "",
    grab: search["grab"] || "",
    "experiment-id": search["experiment-id"] || "",
    idType: search.uidType || COMMON_YANDEXUID,
    scheme: search.scheme || "https",
    debugMode: search.debugMode || "ADVANCED",
    userAgent: search.userAgent || "",
    queryParams: search.queryParams || "",

    grabId: search.grabId || "",

    url: search["url"] || "pogoda.yandex.ru",
    page: search["page"] || "49688",
    "imp-id": search["imp-id"] || "431",
    "aim-banner-id": search["aim-banner-id"] || "",
    "sysconst-update": search["sysconst-update"] || "WinnersMatchLogProbability:1000000,FilterLogProbability:0",
}));
