import { createSelector } from "reselect";
import { getSearchObject } from "src/selectors/router";

export const getGraphParameters = createSelector([getSearchObject], (search) => {
    let left = {
        idValue: search.uid || "",
        idType: search.uidType || "yandexuid",
        matchType: search.matchType || "vulture",
        matchScope: search.matchScope || "crypta_id",
        customMatchType: search.customMatchType,
        depth: search.depth || "1",
    };
    let right = {
        idValueOther: search.uidOther || left.idValue,
        idTypeOther: search.uidTypeOther || left.idType,
        matchTypeOther: search.matchTypeOther || "v2_prod_yt",
        matchScopeOther: search.matchScopeOther || "crypta_id",
        customMatchTypeOther: search.customMatchTypeOther,
        depthOther: search.depthOther || "1",
    };
    return {
        ...left,
        ...right,
        showDiff: search.showDiff === "true" || false,
    };
});
