import { createSelector } from "reselect";
import { getSearchObject } from "src/selectors/router";

export const getMatching = createSelector([getSearchObject], (search) => search.matching || "1");
export const getChapter = createSelector([getSearchObject], (search) => search.chapter || "Search");

export const getProfileIdentifiers = createSelector(
    [(state) => state.bbProfile],
    (bbProfile) => bbProfile.identifiers.value || []
);

export const getProfileIdentifiersLoading = createSelector(
    [(state) => state.bbProfile],
    (bbProfile) => bbProfile.identifiers.isFetching
);
