import { createSelector } from "reselect";
import qs from "query-string";

const getLocation = (state) => state.router.location;

export const getSearchObject = createSelector([getLocation], (location) => qs.parse(location.search));
export const getSearch = createSelector([getLocation], (location) => location.search);
export const getPath = createSelector([getLocation], (location) => location.pathname);
