import { createAction, handleActions } from "redux-actions";
import { getEnv } from "./env";

export const setEnvType = createAction("get env type");

export function fetchEnvType() {
    return (dispatch) => {
        getEnv().then((env) => {
            dispatch(setEnvType(env.CLIENT_ENV_TYPE));
        });
    };
}

export const envReducer = handleActions(
    {
        [setEnvType]: (state, { payload }) => ({
            ...state,
            type: payload,
        }),
    },
    {
        type: "production",
        version: null, // PLACEHOLDER replaced by webpack
    }
);
