import React, { useState } from "react";
import { connect, useDispatch } from "react-redux";
import { isEmpty } from "lodash";
import { useTranslation } from "react-i18next";
import { MessageBox, Button } from "@lib/components/lego";
import { ErrorNotificationBody } from "@lib/components/notifications";

import { getEnvTypeState } from "../selectors";
import { dropAllNotifications, getNotificationsState, removeNotification } from "./notificationsState";

import "./style.scss";

const Notifications = connect((state) => ({
    envType: getEnvTypeState(state),
    values: getNotificationsState(state),
}))((props) => {
    const { values, envType } = props;

    const [showClearButton, setShowClearButton] = useState(true);

    const dispatch = useDispatch();
    const { t } = useTranslation("utils");

    const closeAll = () => {
        setShowClearButton(false);
        dispatch(dropAllNotifications());
    };

    return (
        !isEmpty(values) && (
            <div className="Notifications">
                {Object.keys(values).map((id, index) => {
                    let notification = values[id];
                    if (notification.type === "error") {
                        return (
                            <MessageBox
                                view="default"
                                size="m"
                                onClose={() => dispatch(removeNotification(id))}
                                key={index}
                            >
                                <ErrorNotificationBody
                                    title={notification.title}
                                    status={notification.status}
                                    message={notification.message}
                                    requestId={notification.requestId}
                                    envType={envType}
                                    t={t}
                                />
                            </MessageBox>
                        );
                    }

                    return (
                        <MessageBox view="default" size="s" onClose={() => remove(id)} key={index}>
                            {notification.text}
                        </MessageBox>
                    );
                })}

                {values.length > 4 && showClearButton && (
                    <MessageBox
                        view="default"
                        size="s"
                        actions={
                            <Button view="action" size="s" onClick={closeAll}>
                                {t("closeAll")}
                            </Button>
                        }
                    />
                )}
            </div>
        )
    );
});

export default Notifications;
