import { createAction, handleActions } from "redux-actions";
import { createSelector } from "reselect";
import md5 from "md5";

export const addNotification = createAction("add notification");
export const removeNotification = createAction("remove notification");
export const dropAllNotifications = createAction("drop all notifications");

export const addSuccessNotification = (message) => {
    return (dispatch) => {
        const notification = {
            message: message,
            type: "success",
        };
        dispatch(
            addNotification({
                id: md5(JSON.stringify(notification)),
                value: notification,
            })
        );
    };
};

export const addErrorNotification = (error, title) => {
    return (dispatch) => {
        const notification = {
            title: title,
            status: error.status ? error.status : "",
            message: error.obj ? error.obj.message : "",
            requestId: error.obj ? error.obj.requestId : "",
            type: "error",
        };
        dispatch(
            addNotification({
                id: md5(JSON.stringify(notification)),
                value: notification,
            })
        );
    };
};

export const notificationsReducer = handleActions(
    {
        [addNotification]: (state, { payload }) => ({
            ...state,
            [payload.id]: payload.value,
        }),
        [removeNotification]: (state, { payload }) => {
            let modified = { ...state };
            delete modified[payload];

            return modified;
        },
        [dropAllNotifications]: (state) => state,
    },
    {}
);

const getNotifications = (state) => state.notifications;
export const getNotificationsState = createSelector([getNotifications], (data) => data);
