/* These are custom sorters for sorting BB profile json values
which are presumably strings. So we do parsing numbers.
*/

export function sortByFloat(by, what, descending) {
    return what.sort((a, b) => {
        // Make empty value 0 to put them down in sorting, we do not want to see them
        var bBY = b[by] === null || typeof b[by] === "undefined" || b[by] === "" ? 0 : b[by];
        var aBY = a[by] === null || typeof a[by] === "undefined" || a[by] === "" ? 0 : a[by];

        var diff = parseFloat(bBY) - parseFloat(aBY);
        return descending ? diff : -diff;
    });
}

export function sortByInt(by, what, descending) {
    const radix = 10;
    return what.sort((a, b) => {
        // Make empty value 0 to put them down in sorting, we do not want to see them
        var bBY = b[by] === null || typeof b[by] === "undefined" || b[by] === "" ? 0 : b[by];
        var aBY = a[by] === null || typeof a[by] === "undefined" || a[by] === "" ? 0 : a[by];

        var diff = parseInt(bBY, radix) - parseInt(aBY, radix);
        return descending ? diff : -diff;
    });
}

export function sortAB(by, what, descending) {
    var result = 0;
    return what.sort((a, b) => {
        // Make empty value Я to put them down in sorting, we do not want to see them
        var bBY = b[by] === null || typeof b[by] === "undefined" || b[by] === "" ? "Я" : b[by];
        var aBY = a[by] === null || typeof a[by] === "undefined" || a[by] === "" ? "Я" : a[by];

        var aLessThanB = bBY.toLowerCase() > aBY.toLowerCase();
        if (!aLessThanB) {
            result = 1;
        }
        if (aLessThanB) {
            result = -1;
        }
        return descending ? result : -result;
    });
}
