import re

import auth_client_parser as ap
from flask import Flask, request, redirect

import crypta.web.redirect.src.lib.config as config


def get_yandexuid(request):
    yandexuid = request.cookies.get("yandexuid", "")
    return re.match("^[0-9]+$", yandexuid) and yandexuid or ""


def get_puid(request):
    cookie_str = request.cookies.get("Session_id", "")
    cookie = ap.Cookie(cookie_str)

    try:
        return str(cookie.default_user().uid)
    except RuntimeError:
        return ""


def is_puid_request(request):
    return config.use_puid_key in request.args


def get_or_default(src, host):
    return src.get(host, src.get("default"))


def create_app(name):
    app = Flask(name)

    @app.route("/")
    def index():
        return "OK", 200

    @app.route("/<host>", defaults={'path': ''})
    @app.route("/<host>/", defaults={'path': ''})
    @app.route("/<host>/<path:path>")
    def do_redirect(host, path):
        if host not in config.allowed_hosts:
            destination, code = config.secure_redirect
            return redirect(destination, code=code)

        if path:
            path = "/" + path

        if is_puid_request(request):
            extra = get_or_default(config.puid_redirect_pattern, host).format(id=get_puid(request))
        else:
            extra = get_or_default(config.uid_redirect_pattern, host).format(id=get_yandexuid(request))

        destination = "https://{host}{path}?{extra}&{args}".format(
            host=host,
            path=path,
            extra=extra,
            args=request.query_string.decode(request.charset),
        )

        return redirect(destination, code=307)

    @app.route("/embedded")
    @app.route("/iframe")
    def redirect_to_mini():
        return redirect("https://crypta.yandex-team.ru/mini/me?uid={}".format(get_yandexuid(request)), code=307)

    return app
