module.exports = api => ({
    env: {
        production: {
            plugins: ['transform-react-remove-prop-types'],
        },
    },
    presets: [
        [
            '@babel/preset-env',
            api.caller(caller => caller && caller.target === 'web')
            ? {
                useBuiltIns: 'usage',
                corejs: 2,
                modules: false,
                targets: 'defaults',
            }
            : {
                useBuiltIns: 'usage',
                corejs: 2,
                targets: {
                    node: 'current',
                },
            },
        ],
        '@babel/preset-react',
    ],
    plugins: [
        'syntax-trailing-function-commas',
        'transform-class-properties',
        '@babel/plugin-syntax-object-rest-spread',
        '@babel/plugin-transform-async-to-generator',
        [
            '@babel/plugin-proposal-decorators',
            {
                legacy: true
            },
        ],
        [
            'module-resolver',
            {
                root: ['./src'],
            },
        ],
        [
            '@babel/plugin-transform-runtime',
            {
                regenerator: true,
            },
        ],
    ],
});
