import React, { Component } from "react";

import { Banner } from "@lib/components/pcode";
import Copyable from "@lib/components/copyable";

import "./AdReasons.scss";

export function AdReasons(props) {
    const data = JSON.parse(props.data);

    return <div className="AdReasons">
        <h3>Candidates</h3>
        {
            data.logs.candidates.map(each => {
                return <div key={ each.BannerID }>
                    <div>
                        Banner <Copyable value={ each.BannerID }/>, ST <Copyable value={ each.SelectType }/>
                        <Banner id={ each.BannerID } />
                    </div>
                </div>
            })
        }
    </div>;
}
