import React, { useState, Component } from "react";
import _ from "lodash";

import "./CountLink.scss";

import Copyable from "@lib/components/copyable";
import { Banner } from "@lib/components/pcode";

export function CountLink(props) {
    const { value, parameters } = {
        value: props.children.Value,
        parameters: props.children.Parameters,
    };
    const [hidden, setHidden] = useState(true);

    let half = Math.ceil(parameters.length / 2);

    const parametersMap = _.fromPairs(_.map(parameters, each => [each.Key, each.Value]));

    return (
        <div className="count-link-result">
            <h3>Decoded link</h3>
            <div
                className={
                    hidden ? "count-link-value-hidden" : "count-link-value"
                }
                onClick={() => setHidden(!hidden)}
            >
                {value}
            </div>
            <h3>Banner</h3>
            <div className="banner">
                <Banner id={ parametersMap.BannerID }/>
            </div>
            <h3>Parameters</h3>

            <table>
                <tbody>
                    <tr>
                        {[
                            parameters.slice(0, half),
                            parameters.slice(half),
                        ].map((halfParameters, index) => (
                            <td
                                key={index}
                                className="count-link-parameters-section"
                            >
                                <div
                                    className="count-link-parameters"
                                    key={index}
                                >
                                    <table>
                                        <tbody>
                                            {halfParameters
                                                .slice(0, half)
                                                .map((parameter) => {
                                                    return (
                                                        <tr key={parameter.Key}>
                                                            <td className="count-link-parameter-key">
                                                                {parameter.Key}
                                                            </td>
                                                            <td className="count-link-parameter-value">
                                                                <Copyable
                                                                    value={
                                                                        parameter.Value
                                                                    }
                                                                />
                                                            </td>
                                                        </tr>
                                                    );
                                                })}
                                        </tbody>
                                    </table>
                                </div>
                            </td>
                        ))}
                    </tr>
                </tbody>
            </table>
        </div>
    );
}
