import React, {Component} from "react";

import copyToClipboard from "@lib/utils/clipboard";

import "./ExpStatsWikiButton.scss";
import { sortedKeys } from '../ExpStats/ExpStats';

export class ExpStatsWikiButton extends Component {
    render() {
        const rows = this.props.data.Stats.Rows;
        const headerKeys = this.props.data.Stats.Keys;

        if (rows.length == 0) {
            return null;
        }
        return (
            <span
                className="exp-stats-wiki-copy-button"
                onClick={() => {
                    copyToClipboard(wikiFormat(rows, headerKeys));
                    alert("Copied");
                }}
            >
                wiki format
            </span>
        );
    }
}

function wikiFormat(rows, headerKeys) {
    const keys = sortedKeys(rows, headerKeys);
    var lines = [];
    lines.push("#|");
    keys.forEach((key) => {
        var line = [];
        line.push("||");
        line.push("**" + key + "** |");
        line.push(
            rows
                .map((row) => {
                    if (row.Values[key] === undefined) {
                        return "";
                    }
                    const repr = row.Values[key].Repr;
                    const delta = row.Values[key].Delta;
                    if (delta >= 2) {
                        return "**!!(green)" + repr + "!!**";
                    } else if (delta >= 1) {
                        return "!!(green)" + repr + "!!";
                    } else if (delta > -1) {
                        return repr;
                    } else if (delta > -2) {
                        return "!!(red)" + repr + "!!";
                    } else {
                        return "**!!(red)" + repr + "!!**";
                    }
                })
                .join(" | ")
        );
        line.push("||");
        lines.push(line.join(" "));
    });
    lines.push("|#");
    return lines.join("\n");
}