import React, { Component } from "react";

import { useTranslation } from "react-i18next";
import { get as _get } from "lodash";
import Copyable from "@lib/components/copyable";

import "./Failable.scss";

export function Failable(props) {
    const { failed, errorMessage, children } = props;
    const { t } = useTranslation("common")

    if (failed) {
        return (
            <div className="crypta-search-error-message">
                <React.Fragment>
                    <div key="message" className="message">
                        <span>
                            {_get(
                                errorMessage,
                                "response.obj.message",
                                _.get(
                                    errorMessage,
                                    "message",
                                    "Unknown error"
                                )
                            )}
                        </span>
                    </div>
                    <div key="id" className="request-id">
                        <Copyable
                            value={_get(
                                errorMessage,
                                "response.obj.requestId",
                                ""
                            )}
                        />
                    </div>
                </React.Fragment>
            </div>
        );
    } else {
        return <React.Fragment>{children}</React.Fragment>;
    }
}
