import React from "react";
import { useTranslation } from "react-i18next";
import {
    pointToPair,
    getCenter,
    getRadius,
    getZoom,
    Map,
    Placemark,
} from "@lib/components/map";

import "./Geo.scss";

export function Geo(props) {
    const { regular, actual } = props;
    const { t } = useTranslation("common");

    const allPoints = regular.concat(actual);
    const centerPoint = getCenter(allPoints);
    const radius = getRadius(allPoints, centerPoint);
    const zoom = getZoom(radius);

    return (
        <div className="crypta-user-map-container">
            <Map center={ pointToPair(centerPoint) } zoom={ zoom }>
                {regular.map((point, i) => {
                    return (
                        <Placemark
                            className="geo-marker-inner"
                            properties={{
                                iconContent: t("geo.regular"),
                            }}
                            options={{
                                preset: "islands#darkGreenStretchyIcon",
                            }}
                            key={`regular_${i}`}
                            geometry={[point.latitude, point.longitude]}
                        />
                    );
                })}
                {actual.map((point, i) => {
                    return (
                        <Placemark
                            className="geo-marker-inner"
                            properties={{
                                iconContent: t("geo.actual"),
                            }}
                            options={{
                                preset: "islands#redStretchyIcon",
                            }}
                            key={`regular_${i}`}
                            geometry={[point.latitude, point.longitude]}
                        />
                    );
                })}
            </Map>
        </div>
    );
}
