import React, {Component} from "react";
import { Button } from "@lib/components/lego";

import JSONPretty from "react-json-pretty";

import {connect} from "react-redux";
import {push} from "connected-react-router";
import { doSearch, fetchExamples } from "store/actions/search";

import "./HistoricalSearchRequest.scss";

export const HistoricalSearchRequest = connect(
    (state) => ({
    }),
    (dispatch) => ({
        runQuery: (query) => {
            dispatch(push({ search: "?query=" + query }));
            dispatch(doSearch(query));
        }
    })
)((props) => {
    return <div className="Json SearchHistory">
            <JSONPretty data={props.data.Query}/>
            <Button
                theme="action"
                size="s"
                onClick={() => props.runQuery(props.data.Query)}
            >
                Run
            </Button>
        </div>;
});
