import React, { useCallback } from 'react';
import FontAwesome from 'react-fontawesome';
import './InputTag.scss';

export function InputTag({ name, onClose, ...props }) {
    const handleClose = useCallback(() => {
        onClose();
    }, [onClose]);

    return (
        <span {...props} className="InputTag">
            <span className="InputTag-Text">{name}</span>
            <span className="InputTag-Close" onClick={handleClose}>
                <FontAwesome name="times-circle" />
            </span>
        </span>
    );
}
