import React from 'react';
import { Popup } from '@yandex-lego/components/Popup/desktop/bundle';
import './SuggestPopup.scss';

export function SuggestPopup({
    items,
    visible,
    inputRef,
    onClose,
    onSelect,
}) {
    return (
        <Popup
            target="anchor"
            anchor={inputRef}
            direction={['bottom-start']}
            view="default"
            theme="normal"
            className="SuggestPopup"
            visible={visible}
            onClose={onClose}
        >
            {items.map((value) => (
                <span
                    key={value}
                    className="SuggestPopup-Item"
                    onClick={() => {
                        onSelect(value);
                    }}
                >
                    {value}
                </span>
            ))}
        </Popup>
    );
}
