export function getSuggestData(availableValues, inputValue, maxSuggestCount) {
    if (!inputValue) {
        return [];
    }

    const newSuggestData = [];
    let i = 0;

    while (
        i < availableValues.length &&
        newSuggestData.length < maxSuggestCount
    ) {
        const suggestValue = availableValues[i];

        const isIncludes = (a, b) => a.toLowerCase().includes(b.toLowerCase());

        if (isIncludes(suggestValue, inputValue)) {
            newSuggestData.push(suggestValue);
        }

        i += 1;
    }

    return newSuggestData;
}
