import React, { useState } from "react";

import "./KeywordDescription.scss";

const KEYWORD_ID_KEY = "KeywordID";
const BLIND_KEYWORD_ID_KEY = "BlindKeywordID";
const EXPIRE_DAYS_KEY = "ExpireDays";
const MAX_RECORD_COUNT = "MaxRecordCount";
const VALUE_TYPE_KEY = "ValueType";
const VALUE_TYPE_AS_INT_KEY = "ValueTypeAsInt";

const DATA_GROUP_PREFIX = "DataGroup";
const LOCATION_PREFIX = "Location";
const LOCATION_V2_PREFIX = "LocationV2";
const OPTIONS_PREFIX = "Options";

function renderSingleValues(dataType) {
    return (
        <div className="single-values-container">
            <table>
                <tbody>
                    {[
                        KEYWORD_ID_KEY,
                        BLIND_KEYWORD_ID_KEY,
                        EXPIRE_DAYS_KEY,
                        MAX_RECORD_COUNT,
                        VALUE_TYPE_KEY,
                        VALUE_TYPE_AS_INT_KEY,
                    ].map((key) => {
                        return (
                            <tr key={key}>
                                <td className="datatype-key">{key}</td>
                                <td className="datatype-value">
                                    {dataType[key]}
                                </td>
                            </tr>
                        );
                    })}
                </tbody>
            </table>
        </div>
    );
}

function renderLocation(dataType) {
    let activeValues = Object.entries(dataType).filter(([key, value]) => {
        return (
            key.startsWith(LOCATION_PREFIX) &&
            !key.startsWith(LOCATION_V2_PREFIX) &&
            key !== LOCATION_PREFIX &&
            value
        );
    });

    return renderActiveValues(activeValues, LOCATION_PREFIX);
}

function renderPrefixedValues(dataType, prefix) {
    let activeValues = Object.entries(dataType).filter(([key, value]) => {
        return key.startsWith(prefix) && key !== prefix && value;
    });

    return renderActiveValues(activeValues, prefix);
}

function renderActiveValues(values, prefix) {
    return (
        <span>
            <table className="active-values-table">
                <thead>
                    <tr>
                        <th>{prefix}</th>
                    </tr>
                </thead>
                <tbody>
                    {values.map((item) => {
                        return (
                            <tr key={item[0]}>
                                <td>{item[0]}</td>
                            </tr>
                        );
                    })}
                </tbody>
            </table>
        </span>
    );
}

export function KeywordDescription(props) {
    const { description, dataType } = props;
    const [showExtended, setShowExtended] = useState(false);

    let half;
    let dataTypeEntries;

    if (dataType.length === 1) {
        dataTypeEntries = Object.entries(dataType[0]);
        half = Math.ceil(dataTypeEntries.length / 2);
    }

    return (
        <div className="crypta-keyword">
            <div className="crypta-keyword-description">{description}</div>

            <div className="crypta-keyword-datatype">
                {dataType.length === 1 ? (
                    <div className="crypta-keyword-kategories">
                        {renderSingleValues(dataType[0])}

                        <table className="prefixed-values-table">
                            <tbody>
                                <tr className="prefixed-values-layout">
                                    <td>
                                        {renderPrefixedValues(
                                            dataType[0],
                                            DATA_GROUP_PREFIX
                                        )}
                                    </td>
                                    <td>{renderLocation(dataType[0])}</td>
                                    <td>
                                        {renderPrefixedValues(
                                            dataType[0],
                                            LOCATION_V2_PREFIX
                                        )}
                                    </td>
                                    <td>
                                        {renderPrefixedValues(
                                            dataType[0],
                                            OPTIONS_PREFIX
                                        )}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                ) : (
                    <div />
                )}

                <div
                    className="extended-info"
                    onClick={() => setShowExtended(!showExtended)}
                >
                    {showExtended ? "Hide" : "Extended Info"}
                </div>

                <table
                    className={`datatype-table${showExtended ? "" : "-hidden"}`}
                >
                    <tbody>
                        <tr>
                            {dataType.length === 1 ? (
                                [
                                    dataTypeEntries.slice(0, half),
                                    dataTypeEntries.slice(half),
                                ].map((halfParameters, index) => (
                                    <td
                                        key={index}
                                        className="datatype-parameters-section"
                                    >
                                        <div
                                            className="datatype-parameters"
                                            key={index}
                                        >
                                            <table>
                                                <tbody>
                                                    {halfParameters.map(
                                                        ([key, value]) => {
                                                            return (
                                                                <tr key={key}>
                                                                    <td className="datatype-key">
                                                                        {key}
                                                                    </td>
                                                                    <td className="datatype-value">
                                                                        {JSON.stringify(
                                                                            value
                                                                        )}
                                                                    </td>
                                                                </tr>
                                                            );
                                                        }
                                                    )}
                                                </tbody>
                                            </table>
                                        </div>
                                    </td>
                                ))
                            ) : (
                                <td />
                            )}
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    );
}
