import React from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";

import { searchForSpecialId } from "store/actions/search";

import { Modal } from "@lib/components/lego";
import Loading from "@lib/components/loading";
import { Failable, KeywordDescription } from "components";

import "./KeywordDescriptionModal.scss";


@connect(
    (state) => ({
        result: state.specialSearchResult.payload,
        failed: state.specialSearchResult.error !== null,
        loading: state.specialSearchResult.loading,
    }),
    (dispatch) => ({
        searchForSpecialId: (id) => dispatch(searchForSpecialId(id)),
    })
)
class KeywordDescriptionContent extends React.Component {
    componentDidMount() {
        const { keywordId } = this.props;
        if (keywordId !== null) {
            this.props.searchForSpecialId("keyword " + keywordId);
        }
    }

    componentDidUpdate(prevProps) {
        if (prevProps.keywordId !== this.props.keywordId) {
            if (this.props.keywordId !== null) {
                this.props.searchForSpecialId(
                    "keyword " + this.props.keywordId
                );
            }
        }
    }

    render() {
        const { result } = this.props;

        let description = {};
        if (result.length === 1) {
            description = result[0].Value.Keyword;
        }

        return (
            <div className="keyword-description-modal">
                <Loading loaded={!this.props.loading}>
                    <Failable
                        failed={this.props.failed || isEmpty(description)}
                        errorMessage={this.props.message}
                    >
                            <div className="keyword-description-modal-content">
                                <h3 className="keyword-description-id-modal-heading">
                                    Keyword Id {this.props.keywordId}
                                </h3>

                                <KeywordDescription
                                    description={description.Description}
                                    dataType={description.DataTypes}
                                />
                            </div>
                    </Failable>
                </Loading>
            </div>
        );
    }
}

export class KeywordDescriptionModal extends React.Component {
    render() {
        const { visible, keywordId, closeModal } = this.props;

        return (
            <div>
                <Modal
                    onClose={() => closeModal()}
                    theme="normal"
                    visible={visible}
                    zIndexGroupLevel={20}
                >
                    {visible && (
                        <KeywordDescriptionContent
                            keywordId={keywordId}
                            visible={visible}
                            closeModal={closeModal}
                        />
                    )}
                </Modal>
            </div>
        );
    }
}
