import React, { useState } from "react";
import { Link } from "react-router-dom";

import { KeywordDescriptionModal } from "components";

import "./KeywordsDigest.scss";

function Values(props) {
    const { values, openSpecificDescription } = props;
    const keywordPath = "?query=keyword ";

    return (
        <table>
            <thead>
                <tr>
                    <th className="keyword-description-id">id</th>
                    <th>Description</th>
                </tr>
            </thead>
            <tbody>
                {Object.entries(values).map(([id, description]) => {
                    return (
                        <tr
                            key={id}
                            className="crypta-keywords-digest-description"
                        >
                            <td className="keyword-description-id">
                                <Link
                                    to={keywordPath + id}
                                    onClick={(event) =>
                                        openSpecificDescription(event, id)
                                    }
                                >
                                    {id}
                                </Link>
                            </td>
                            <td className="keyword-description-value">
                                <Link
                                    to={keywordPath + id}
                                    onClick={(event) =>
                                        openSpecificDescription(event, id)
                                    }
                                >
                                    {description}
                                </Link>
                            </td>
                        </tr>
                    );
                })}
            </tbody>
        </table>
    );
}

export function KeywordsDigest(props) {
    const [activeKeywordId, setActiveKeywordId] = useState(null);
    const [specificDescriptionOpen, setSpecificDescriptionOpen] = useState(
        false
    );

    const openSpecificDescription = (event, keywordId) => {
        event.preventDefault();

        setSpecificDescriptionOpen(true);
        setActiveKeywordId(keywordId);
    };

    const closeSpecificDescription = () => {
        setSpecificDescriptionOpen(false);
    };

    return (
        <div className="crypta-keywords-digest">
            <Values
                values={props.keywords}
                openSpecificDescription={openSpecificDescription}
            />
            <KeywordDescriptionModal
                closeModal={closeSpecificDescription}
                visible={specificDescriptionOpen}
                keywordId={activeKeywordId}
            />
        </div>
    );
}
