import React, { useCallback } from 'react';
import { Form, Field } from 'react-final-form';
import { Button } from '@yandex-lego/components/Button/desktop/bundle';
import { ButtonGroup } from '@yandex-lego/components/ButtonGroup/desktop/bundle';
import { Textinput } from '@yandex-lego/components/Textinput/desktop/bundle';
import { useSelector, useDispatch } from 'react-redux';
import { applyLtpFilter, clearLtpFilter, loadLtpResult } from 'store/actions/ltp';
import { getLtp, ltpFilterForm } from 'store/selectors/ltp';

import './LtpViewerForm.scss';

const FIELDS = [
    'Limit',
    'SourceTypeFilter',
    'FromEventTs',
    'ToEventTs',
    'IdFilter',
    'IdTypeFilter',
    'DescriptionFilter',
    'AdditionalDescriptionFilter',
];

const CUSTOM_LABELS = {
    Limit: 'Количество записей на странице'
};

export function LtpViewerForm() {
    const dispatch = useDispatch();

    const { isTableLoading } = useSelector(getLtp);
    const initialValues = useSelector(ltpFilterForm)

    return (
        <Form
            initialValues={initialValues}
            onSubmit={(formState) => {
                dispatch(applyLtpFilter(validateForm(formState)));
            }}
            subscription={{ submitting: true }}
            render={({ form, handleSubmit }) => (
                <div className="LtpViewerForm">
                    {FIELDS.map((field) => (
                        <div key={field} className="LtpViewerForm-Row">
                            <div className="LtpViewerForm-Label">
                                {CUSTOM_LABELS[field] ?? field}
                            </div>
                            <Field
                                name={field}
                                render={(props) => (
                                    <Textinput
                                        size="s"
                                        view="default"
                                        disabled={isTableLoading}
                                        value={props.input.value}
                                        onChange={props.input.onChange}
                                    />
                                )}
                            />
                        </div>
                    ))}
                    <ButtonGroup gap="xl">
                        <Button
                            size="s"
                            view="action"
                            onClick={handleSubmit}
                            progress={isTableLoading}
                        >
                            Применить
                        </Button>
                        <Button
                            size="s"
                            view="pseudo"
                            onClick={() => {
                                form.reset();
                                dispatch(clearLtpFilter())
                            }}
                            progress={isTableLoading}
                        >
                            Сбросить
                        </Button>
                    </ButtonGroup>
                </div>
            )}
        />
    );
}

function validateForm(formState) {
    const limit = Number(formState.Limit);

    if (!isFinite(limit) || limit < 1) {
        formState.Limit = 1;
    }

    return formState;
}