import React from "react";
import { useSelector } from "react-redux";
import classNames from "classnames";
import { getLtp } from "store/selectors/ltp";

import "./LtpViewerHistory.scss";

/**
 * @typedef LtpViewerHistoryProps
 * @property {(resultId: string) => void} onLoad
 *
 * @param {LtpViewerHistoryProps} props
 */
export function LtpViewerHistory({ onLoad, ...rest }) {
    const {
        resultId: activeResultId,
        allResultIdList,
        isHistoryLoading,
        fromDate: activeFromDate,
        toDate: activeToDate,
    } = useSelector(getLtp);

    const isLoading = isHistoryLoading && allResultIdList.length === 0;

    return (
        <div {...rest} className="LtpViewerHistory">
            {isLoading && <span>history loading...</span>}
            {allResultIdList.map(
                ({ resultId, ready, id, idType, fromDate, toDate }) => {
                    const isActive =
                        resultId === activeResultId &&
                        fromDate == activeFromDate &&
                        toDate == activeToDate;

                    return (
                        <div
                            key={resultId + fromDate + toDate}
                            className={classNames(
                                "LtpViewerHistory-Item",
                                isActive && "LtpViewerHistory-Item_active"
                            )}
                            onClick={() => {
                                if (!isActive) {
                                    onLoad(
                                        resultId,
                                        id,
                                        idType,
                                        fromDate,
                                        toDate
                                    );
                                }
                            }}
                        >
                            <div className="LtpViewerHistory-Item-Content">
                                <span>Id: {id}</span>
                                <br />
                                <span>IdType: {idType}</span>
                                <br />
                                <span>
                                    {fromDate} {toDate && ` / ${toDate}`}
                                </span>
                            </div>
                            <div
                                className={`LtpViewerHistory-${
                                    ready ? "Ready" : "Loading"
                                }`}
                            />
                        </div>
                    );
                }
            )}
        </div>
    );
}
