import React from "react";
import { useSelector } from "react-redux";
import { getLtp } from "store/selectors/ltp";
import { TooltipStateful } from "@lib/components/lego";
import { range } from "lodash";

import "./LtpViewerProgressBar.scss";

export function LtpViewerProgressBar() {
    const { progress } = useSelector(getLtp);

    if (!progress || !progress.Scheduled) {
        return <span>Not started</span>;
    }

    const width = 3;
    let keys = Object.keys(progress.StatsByDate);
    keys.sort();

    return (
        <span className="LtpViewerProgressBar-Panel">
            <svg
                width={keys.length * width}
                className="LtpViewerProgressBar-Bar"
            >
                {keys.map((date, i) => {
                    return (
                        <TooltipStateful
                            key={date}
                            size="s"
                            view="default"
                            content={date}
                            hasTail
                        >
                            <rect
                                width={width}
                                x={i * width}
                                className={
                                    "LtpViewerProgressBar-BarItem " +
                                    (progress.StatsByDate[date].Total ===
                                    progress.StatsByDate[date].Completed
                                        ? "LtpViewerProgressBar-Completed"
                                        : progress.StatsByDate[date].Failed > 0
                                        ? "LtpViewerProgressBar-Failed"
                                        : "LtpViewerProgressBar-Processing")
                                }
                            />
                        </TooltipStateful>
                    );
                })}
            </svg>
            <span className="LtpViewerProgressBar-Percents">
                <span className="LtpViewerProgressBar-Text-Completed">
                    {render_percent(
                        progress.Stats.Completed / progress.Stats.Total
                    )}
                </span>{" "}
                /{" "}
                <span className="LtpViewerProgressBar-Text-Processing">
                    {render_percent(
                        (progress.Stats.Total -
                            progress.Stats.Completed -
                            progress.Stats.Failed) /
                            progress.Stats.Total
                    )}{" "}
                </span>
                /{" "}
                <span className="LtpViewerProgressBar-Text-Failed">
                    {render_percent(
                        progress.Stats.Failed / progress.Stats.Total
                    )}
                </span>
            </span>
        </span>
    );
}

function render_percent(value) {
    return Math.round(value * 100) + "%";
}
