import React from 'react';
import { Field } from 'react-final-form';
import { Checkbox } from '@yandex-lego/components/Checkbox/desktop/bundle';
import { CONTROLS } from './const';

export function FormCheckbox({ name }) {
    return (
        <div>
            <div className="Repin-Label">{CONTROLS[name].title}</div>
            <div className="Repin-Row">
                {[...CONTROLS[name].data.values()].map((value, index) => (
                    <Field
                        key={`${name}[${index}]`}
                        name={`${name}[${index}]`}
                        render={props => (
                            <Checkbox
                                size="s"
                                view="default"
                                label={value}
                                checked={props.input.value}
                                onChange={props.input.onChange}
                            />
                        )}
                    />
                ))}
            </div>
        </div>
    )
}
