import React from 'react';
import { Field } from 'react-final-form';

import { InputWithTags } from 'components';

import { serializeTags, deserializeTags } from './utils'

export function FormInputWithTags({ name, ...rest }) {
    return (
        <Field
            name={name}
            render={props => (
                <InputWithTags
                    tags={deserializeTags(props.input.value ?? '')}
                    onTagsChange={(newTags) => {
                        return props.input.onChange(
                            serializeTags(newTags),
                        );
                    }}
                    {...rest}
                />
            )}
        />
    );
}
