import React from 'react';
import { Field } from 'react-final-form';
import { FieldArray } from 'react-final-form-arrays';

import { Button } from '@yandex-lego/components/Button/desktop/bundle';
import { RadioButton } from '@yandex-lego/components/RadioButton/desktop/bundle';
import { Icon } from '@yandex-lego/components/Icon/desktop/bundle';

import { FormInputWithTags } from './FormInputWithTags';
import { CONTROLS, DEFAULT_MULTI_RADIO_INPUT } from './const';

export function FormMultiRadioInput({ name, children, ...rest }) {
    return (
        <FieldArray
            subscription={{ submitting: true }}
            name={name}
        >
            {({ fields }) =>
                <div className="FormMultiRadioInput">
                    <div className="Repin-Label">
                        {CONTROLS[name].title}
                    </div>
                    {fields.map((field, index) => (
                        <div className="FormMultiRadioInput-Elem" key={field}>
                        <FormInputWithTags name={`${field}.input`} {...rest}>
                            <Field
                                name={`${field}.radio`}
                                render={(props) => (
                                    <RadioButton
                                        size="s"
                                        view="default"
                                        options={CONTROLS[name].options}
                                        value={props.input.value}
                                        onChange={props.input.onChange}
                                    />
                                )}
                            />
                        </FormInputWithTags>
                        <Icon
                            className="Icon"
                            size="l"
                            glyph="type-cross"
                            onClick={() => { fields.remove(index) }}
                        />
                        {index < fields.length - 1 && <div className="Badge">И</div>}
                    </div>
                    ))}
                    {fields.length < 5 && (
                        <Button
                            size="s"
                            view="default"
                            pin="circle-circle"
                            onClick={() => fields.push({ ...DEFAULT_MULTI_RADIO_INPUT })}
                        >
                            +
                        </Button>
                    )}
                </div>
            }
        </FieldArray>
    );
}
