import React from 'react';
import { Field } from 'react-final-form';
import { RadioButton } from '@yandex-lego/components/RadioButton/desktop/bundle';
import { CONTROLS } from './const';

export function FormRadioButton({ name }) {
    return (
        <Field name={name}
            render={props => (
                <div>
                    <div className="Repin-Label">
                        {CONTROLS[name].title}
                    </div>
                    <RadioButton
                        size="s"
                        view="default"
                        options={CONTROLS[name].options}
                        value={props.input.value}
                        onChange={props.input.onChange}
                    />
                </div>
            )}
        />
    );
}
