import React from 'react';
import { Field } from 'react-final-form';
import { Radiobox } from '@yandex-lego/components/Radiobox/desktop/bundle';
import { CONTROLS } from './const';

export function FormRadiobox({ name, text }) {
    return (
        <Field
            name={name}
            render={props => (
                <div className="FormRadiobox">
                    <div className="Repin-Label">
                        {CONTROLS[name].title}
                    </div>
                    <span>{text}&nbsp;</span>
                    <Radiobox
                        size="s"
                        view="default"
                        options={CONTROLS[name].options}
                        value={props.input.value}
                        onChange={props.input.onChange}
                    />
                </div>
            )}
        />
    )
}
