import React, { useMemo } from 'react';
import { FormInputWithTags } from './FormInputWithTags';
import { Type, CONTROLS } from './const';
import { getRegions, isValidRegion } from './utils';

export function RegionsInput() {
    const regionSuggest = useMemo(() => getRegions(), []);

    const { title } = CONTROLS[Type.Regions];

    return (
        <div>
            <div className="Repin-Label">{title}</div>
            <div className="Repin-Row">
                <FormInputWithTags
                    name={Type.Regions}
                    suggest={regionSuggest}
                    validator={isValidRegion}
                />
            </div>
        </div>
    );
}
