export const Type = {
    Gender: 'Gender',
    Ages: 'Ages',
    Incomes: 'Incomes',
    Countries: 'Countries',
    Regions: 'Regions',
    Devices: 'Devices',
    Hosts: 'Hosts',
    Phrases: 'Phrases',
    Apps: 'Apps',
    Aggregate: 'Aggregate',
};

export const CONTROLS = {
    [Type.Gender]: {
        title: 'Пол',
        options: [
            { value: '', children: 'Любой' },
            { value: 'MALE', children: 'Мужской' },
            { value: 'FEMALE', children: 'Женский' },
        ],
    },
    [Type.Ages]: {
        title: 'Возраст',
        data: new Map([
            ['FROM_0_TO_17', '0-17',],
            ['FROM_18_TO_24', '18-24'],
            ['FROM_25_TO_34', '25-34'],
            ['FROM_35_TO_44', '35-44'],
            ['FROM_45_TO_54', '45-54'],
            ['FROM_55_TO_99', '55-99'],
        ])
    },
    [Type.Incomes]: {
        title: 'Доход',
        data: new Map([
            ['INCOME_A', 'низкий (a)'],
            ['INCOME_B1', 'ниже среднего (b1)'],
            ['INCOME_B2', 'выше среднего (b2)'],
            ['INCOME_C1', 'высокий (c1)'],
            ['INCOME_C2', 'премиум (c2)'],
        ])
    },
    [Type.Countries]: {
        title: 'Страны',
        data: new Map([
            ['RUSSIA', 'Россия'],
            ['TURKEY', 'Турция'],
            ['UKRAINE', 'Украина'],
            ['BELARUS', 'Белоруссия'],
            ['KAZAKHSTAN', 'Казахстан'],
        ])
    },
    [Type.Devices]: {
        title: 'Устройства',
        data: new Map([
            ['DESKTOP', 'компьютер'],
            ['PHONE', 'телефон'],
            ['TABLET', 'планшет'],
            ['MIXED', 'смешанный'],
        ])
    },
    [Type.Hosts]: {
        title: 'Посещенные сайты',
        options: [{ value: 'or', children: 'любой из' }, { value: 'not', children: 'ни один из' }],
    },
    [Type.Phrases]: {
        title: 'Поисковые фразы',
        options: [{ value: 'or', children: 'любая из' }, { value: 'not', children: 'ни одна из' }],
    },
    [Type.Apps]: {
        title: 'Приложения',
        options: [{ value: 'or', children: 'любое из' }, { value: 'not', children: 'ни одно из' }],
    },
    [Type.Aggregate]: {
        title: 'Аггрегация сайтов, поисковых фраз, приложений',
        options: [{ value: 'or', label: 'ИЛИ' }, { value: 'and', label: 'И' }],
    },
    [Type.Regions]: {
        title: 'Регионы',
    },
};

export const DEFAULT_MULTI_RADIO_INPUT = { radio: 'or', input: '' };
