import { keyBy } from 'lodash';
import { Type } from '../const';

import regions from '../../../../public/regions.json'; // можно подгружать через AJAX чтобы не увеличивать размер бандла

const REGIONS_RU = keyBy(regions, 'name');
// const REGIONS_EN = keyBy(regions, 'en_name');
const REGIONS = {
    ...REGIONS_RU,
    // ...REGIONS_EN,
};
const REGIONS_CACHE = {};

export const getRegions = () => Object.keys(REGIONS);

export const isValidRegion = (name) => (name in REGIONS);

const findRegionById = (regionId) => {
    const cached = REGIONS_CACHE[regionId];

    if (cached) {
        return cached.name;
    }

    const region = regions.find(
        (item) => item.region === regionId,
    );

    REGIONS_CACHE[regionId] = region;

    return region.name;
};

export function restoreRegions(json) {
    const regionsData = json[Type.Regions] ?? [];
    return regionsData.map(findRegionById);
}

export function mapRegionsToApiFormat(regionNames) {
    const regionIds = regionNames.map((regionName) => {
        const { region: regionId } = REGIONS[regionName];

        REGIONS_CACHE[regionId] = REGIONS[regionName];

        return regionId;
    });

    return [...new Set(regionIds)];
}
