import React, { Component } from "react";
import FontAwesome from "react-fontawesome";

import copyToClipboard from "@lib/utils/clipboard";
import Panel from "@lib/components/panel";
import { formatDate } from "@lib/components/time";

import "./SimpleResultBox.scss";

export class SimpleResultBox extends Component {
    render() {
        const { heading, cached, ts, url, buttons, toCopy } = this.props;

        const cachedLabel = ts
            ? `Cached at ${formatDate(ts)}. Use '&nocache' url parameter to avoid caching.`
            : '';

        return (
            <Panel>
                <div className="simple-result-box">
                    <div className="simple-result-heading">
                        {heading}

                        <div>
                            {url && url !== "" &&
                                <div className="details">
                                    <a href={url}>See more</a>
                                </div>
                            }
                            <div className="buttons">
                                {cached &&
                                    <FontAwesome
                                        name="database"
                                        className="copy-button"
                                        title={cachedLabel}
                                    />
                                }
                                {buttons}
                                <FontAwesome
                                    onClick={toCopy ?
                                        () => copyToClipboard(toCopy)
                                        : undefined}
                                    className="copy-button"
                                    name="copy"
                                />

                            </div>
                        </div>
                    </div>

                    <div className="simple-result-content">
                        {this.props.children}
                    </div>
                </div>
            </Panel>
        );
    }
}
