import React from "react";

import { GenderChart, AgeChart, IncomeChart } from "components";

import "./Socdem.scss";

export class Socdem extends React.Component {
    render() {
        const { profile } = this.props;

        return (
            <div className="socdem-block">
                <GenderChart
                    values={profile.Gender}
                    exact={profile.ExactSocdem.gender}
                    rt_exact={profile.ExactSocdemRt.gender}
                />
                <AgeChart
                    values={profile.Age}
                    exact={profile.ExactSocdem.age6}
                    rt_exact={profile.ExactSocdemRt.age6}
                />
                <IncomeChart
                    values={profile.Income}
                    exact={profile.ExactSocdem.income5}
                    rt_exact={profile.ExactSocdemRt.income5}
                />
            </div>
        );
    }
}
