import React, { Component } from "react";
import { sortBy } from "lodash";

import { Banner } from "@lib/components/pcode";

import "./UserHistory.scss";

function getSearchBannerUrl(id) {
    return `https://direct.yandex.ru/registered/main.pl?cmd=searchBanners&reverse=1&sort=price&where=direct&what=banner_id&subtype=id&text_search=${id}&include_currency_archived_campaigns=on&search_or_net=&retargetings=&strategy=&use_bansearch=0`;
}

function formatTime(s) {
    if (!s) {
        return "<>";
    }
    const dtFormat = new Intl.DateTimeFormat('ru-RU', {
        timeStyle: 'medium',
        dateStyle: 'medium',
        timeZone: 'Europe/Moscow'
    });

    return dtFormat.format(new Date(s * 1e3));
}


function Event(props) {
    return <div className={ "Event " + (props.className || "") }>
        <div className="Time">{ formatTime(props.time) }</div>
        <div className="Circle" />
        { props.children }
    </div>
}

function BrowserEvent(props) {
    const { data } = props;
    return <Event time={ data.Time } className="Browser">
        <div className="Title">{ data.Title }</div>
        <div className="Url"><a href={ data.Url }>{ data.Url }</a></div>
    </Event>;
}

function VisitEvent(props) {
    const { data } = props;
    return <Event time={ data.Time } className="Visit">
        <div className="Title">Посещена страница</div>
        <div className="Url"><a href={ data.Url }>{ data.Url }</a></div>
    </Event>;
}

function AdShowEvent(props) {
    const { data } = props;
    return <Event time={ data.Time } className="AdShow">
        <div className="ID">Показан баннер <a href={ getSearchBannerUrl(data.BannerID) }>{ data.BannerID }</a></div>
        <div className="Banner">
            <Banner id={ data.BannerID } />
        </div>
    </Event>;
}

function AdClickEvent(props) {
    const { data } = props;
    return <Event time={ data.Time } className="AdClick">
        <div className="ID">Кликнут баннер <a href={ getSearchBannerUrl(data.BannerID) }>{ data.BannerID }</a></div>
        <div className="Banner">
            <Banner id={ data.BannerID } />
        </div>
    </Event>;
}

function RequestEvent(props) {
    const { data } = props;
    return <Event time={ data.Time / 1000 } classname="Request">
        <div className="Title">Задан поисковый запрос: { data.Query }</div>
    </Event>;
}

function FacebookEvent(props) {
    const { data } = props;
    return <Event time={ data.Time } className="Facebook">
        <div className="Title">Реклама в фейсбуке</div>
        { data.Title.trim() && <div className="Heading"><h3>{ data.Title.trim() }</h3></div> }
        { data.Text.trim() && <div className="Text"><p>{ data.Text.trim() }</p></div> }
        <ul>
        {
            data.Banners.map((x, i) => {
                const text = x.Text.trim();
                const subtext = x.Subtext.trim();
                const imgUrl = x.ImgUrl.trim();
                if (text || subtext) {
                    return <li key={ i }>
                        { text && <div className="Text">{ text }</div> }
                        { subtext && <div className="Subtext">{ subtext }</div> }
                        { imgUrl && <div className="Url"><a href={ imgUrl }>image</a></div> }
                    </li>;
                }
            })
        }
        </ul>
    </Event>;
}

function UnknownEvent(props) {
    const { data } = props;
    return <Event>No idea</Event>;
}

export function UserHistory(props) {
    const { data } = props;
    const events = sortBy(JSON.parse(data).map(each => each.Event), each => each.Time);
    const renderers = {
        Browser: (data, key) => <BrowserEvent key={ key } data={ data } />,
        Visit: (data, key) => <VisitEvent key={ key } data={ data } />,
        Request: (data, key) => <RequestEvent key={ key } data={ data }/>,
        AdShow: (data, key) => <AdShowEvent key={ key } data={ data } />,
        AdClick: (data, key) => <AdClickEvent key={ key } data={ data } />,
        Facebook: (data, key) => <FacebookEvent key={ key } data={ data } />
    }

    return <div className="UserHistory">
        {
            events.map((x, i) => {
                if (x.Type in renderers) {
                    return renderers[x.Type](x, i);
                } else {
                    return <UnknownEvent key={ i } data={ x } />;
                }
            })
        }
    </div>;
}
