import React from "react";

import { DemographicChart } from "./helpers/DemographicChart";

export const LABELS = {
    A: "$/A",
    B1: "$$/B1",
    B2: "$$+/B2",
    C1: "$$$/C1",
    C2: "$$$+/C2",
};

export class IncomeChart extends React.Component {
    render() {
        const { values, exact, rt_exact } = this.props;

        return (
            <DemographicChart
                labels={LABELS}
                values={values}
                exact={exact}
                rt_exact={rt_exact}
            />
        );
    }
}
