import React from "react";
import * as d3 from "d3";

const START_ANGLE = -90 * (Math.PI / 180);
const END_ANGLE = 90 * (Math.PI / 180);

const COLOR = d3
    .scaleOrdinal()
    .range(["#68c8d7", "#eccd63", "#bb8cdd", "#de6942", "#52b36e", "#bbc7d9"]);

export class HalfDonutChart extends React.Component {
    createChart(radius, data, color, pie) {
        let outerRadius = radius / 2;
        let innerRadius = radius / 3.3;

        let arc = d3.arc().outerRadius(outerRadius).innerRadius(innerRadius);

        return pie(data).map((d, i) => {
            return (
                <path
                    fill={color(i)}
                    d={arc(d)}
                    key={i}
                    onMouseOver={() => this.props.handleMouseOver(d.data)}
                    onMouseLeave={() => this.props.handleMouseLeave()}
                />
            );
        });
    }

    render() {
        let pie = d3
            .pie()
            .value((d) => d.count)
            .padAngle(0)
            .startAngle(START_ANGLE)
            .endAngle(END_ANGLE)
            .sort(null);

        let radius = this.props.width;
        const { width, data } = this.props;

        return (
            <div>
                <svg width={width} height={width / 2}>
                    <g transform={`translate(${radius / 2},${radius / 2})`}>
                        {this.createChart(radius, data, COLOR, pie)}
                    </g>
                </svg>
            </div>
        );
    }
}
