import { useRef, useEffect, useCallback } from 'react';

export const useEnterPress = (callback, inputDeps) => {
    const deps = inputDeps ?? [callback];
    const callbackRef = useRef(callback);

    useEffect(() => {
        callbackRef.current = callback;
    }, deps);

    const onKeyDown = useCallback((e) => {
        if (e.keyCode === 13) {
            callbackRef.current();
        }
    }, []);

    return onKeyDown;
};
