import i18n from "i18next";
import { initReactI18next } from "react-i18next";
import Backend from "i18next-xhr-backend";

import common_en from "./en/common.json";
import common_ru from "./ru/common.json";

import lib_en from "@lib/i18n/en/lib.json";
import lib_ru from "@lib/i18n/ru/lib.json";

i18n
    .use(Backend)
    .use(initReactI18next)
    .init({
        fallbackLng: "ru",
        debug: true,
        lng: "ru",

        react: {
            useSuspense: false,
        },

        interpolation: {
            escapeValue: false, // not needed for react as it escapes by default
        },

        resources: {
            en: {
                common: common_en,
                lib: lib_en,
            },
            ru: {
                common: common_ru,
                lib: lib_ru,
            },
        },
    });

export default i18n;
