import { createAction } from "redux-actions";

import { getLtpResult, getUserHistory, getLtpProgress } from "clients";

export const setLtpResultId = createAction("ltp result set id");
export const resetLtp = createAction("ltp reset state");

export const requestLtpResult = createAction("ltp result requested");
export const receiveLtpResult = createAction("ltp result received");
export const failedLtpResult = createAction("ltp result failed");

export const requestLtpHistory = createAction("ltp history requested");
export const receiveLtpHistory = createAction("ltp history received");
export const failedLtpHistory = createAction("ltp history failed");

export const toggleLtpFilter = createAction("ltp filter toggle");
export const applyLtpFilter = createAction("ltp filter apply");
export const clearLtpFilter = createAction("ltp filter clear");

export const requestLtpProgress = createAction("ltp progress requested");
export const receiveLtpProgress = createAction("ltp progress received");
export const failedLtpProgress = createAction("ltp progress failed");

/**
 * @typedef LtpProfileRequestOptions
 * @property {string} ResultID
 * @property {number} FromEventTs
 * @property {number} ToEventTs
 * @property {string} SourceTypeFilter
 * @property {string} DescriptionFilter
 * @property {string} DescriptionUrlFilter
 * @property {string} AdditionalDescriptionFilter
 * @property {string} AdditionalDescriptionUrlFilter
 * @property {number} Offset
 * @property {number} Limit
 */

/**
 * @param {LtpProfileRequestOptions} options
 */
export function loadLtpResult(options) {
    return function (dispatch) {
        dispatch(requestLtpResult());

        getLtpResult(options)
            .then(({ obj: { Items, Ready, TotalRecs } }) => {
                dispatch(
                    receiveLtpResult({
                        items: Items,
                        ready: Ready,
                        total: TotalRecs,
                    })
                );
            })
            .catch((error) => {
                dispatch(failedLtpResult(error));
            });
    };
}

export function loadLtpHistory() {
    return function (dispatch) {
        dispatch(requestLtpHistory());

        getUserHistory()
            .then((result) => {
                dispatch(
                    receiveLtpHistory(
                        result.obj.items.map(
                            ({
                                OriginalRequest: {
                                    Id,
                                    IdType,
                                    FromDate,
                                    ToDate,
                                },
                                ResultID,
                                Ready,
                            }) => ({
                                resultId: ResultID,
                                ready: Ready,
                                fromDate: FromDate,
                                toDate: ToDate,
                                id: Id,
                                idType: IdType,
                            })
                        )
                    )
                );
            })
            .catch((error) => {
                dispatch(failedLtpHistory(error));
            });
    };
}

export function loadLtpProgress(Id, IdType, FromDate, ToDate) {
    return function (dispatch) {
        dispatch(requestLtpProgress());

        getLtpProgress({ Id, IdType, FromDate, ToDate })
            .then((payload) => {
                dispatch(receiveLtpProgress(payload.obj));
            })
            .catch((error) => {
                dispatch(failedLtpProgress(error));
            });
    };
}
