import { push, replace } from "connected-react-router";
import { stringify } from "query-string";

import { getSearchObject } from "store/selectors/query";

function setSearchParam(key, value, refresh) {
    return (dispatch, getState) => {
        let search = getSearchObject(getState());

        search[key] = value;

        dispatch(push({ search: stringify(search) }));

        if (refresh) {
            dispatch(reload());
        }
    };
}

function reload() {
    return (dispatch) => {
        window.location.reload();
    };
}

export function setQuery(query) {
    return setSearchParam("query", query, false);
}

export function dropQuery() {
    return (dispatch) => {
        dispatch(replace({ search: "" }));
        dispatch(reload());
    };
}
