
import { handleActions } from "redux-actions";
import { API } from "clients";
import { gotApi, updateNow } from "store/actions/search";

export const baseReducer = handleActions(
    {
        [gotApi]: (state, { payload }) => ({
            ...state,
            apiInfo: { version: payload.version, host: payload.host },
        }),
        [updateNow]: (state, { payload }) => ({ ...state, now: payload }),
    },
    {
        api: API,
        apiInfo: {},
    }
);