import { connectRouter } from "connected-react-router";
import { combineReducers } from "redux";

import { baseReducer } from "store/reducers/base";
import { ltpResultReducer } from "./ltp";

import {
    searchResult,
    specialSearchResult,
    searchExamples,
} from "store/reducers/search";

export default (history) =>
    combineReducers({
        router: connectRouter(history),
        base: baseReducer,
        searchResult,
        ltp: ltpResultReducer,
        searchExamples,
        specialSearchResult,
    });
